﻿<?php include 'head.php'; ?>

<?php
// ---------------- Cache ----------------
$cacheDir  = dirname(__FILE__).'/cache';
$cacheFile = $cacheDir.'/guild_ranking.txt';
$cacheTtl  = 3600; // 1 saat

if (!is_dir($cacheDir)) { @mkdir($cacheDir, 0775, true); }

$result = '';
$stale  = !is_file($cacheFile) || filemtime($cacheFile) < time() - $cacheTtl;

if ($stale) {
    $query = "
        SELECT TOP (20)
            g.ID,
            g.Name,
            g.Lvl,
            g.GatheredSP,

            -- Guild master bilgileri (kullanmÄ±yorsan yine de bÄ±rakÄ±yorum)
            (SELECT TOP(1) gm1.CharID
               FROM SILKROAD_R_SHARD.._GuildMember gm1 WITH (NOLOCK)
               WHERE gm1.GuildID = g.ID AND gm1.MemberClass = 0) AS MasterID,
            (SELECT TOP(1) gm2.CharName
               FROM SILKROAD_R_SHARD.._GuildMember gm2 WITH (NOLOCK)
               WHERE gm2.GuildID = g.ID AND gm2.MemberClass = 0) AS MasterName,

            (SELECT COUNT(*) 
               FROM SILKROAD_R_SHARD.._GuildMember gm3 WITH (NOLOCK)
               WHERE gm3.GuildID = g.ID) AS TotalMember,

            (
                SUM(i.OptLevel)
              + SUM(roi.ItemClass)
              + SUM(roc.Rarity)
              + SUM(CASE WHEN bo.nItemDBID IS NULL THEN 0 ELSE bo.nOptValue END)
            ) AS ItemPoints

        FROM SILKROAD_R_SHARD.._Guild            g  WITH (NOLOCK)
        INNER JOIN SILKROAD_R_SHARD.._GuildMember gm WITH (NOLOCK) ON g.ID      = gm.GuildID
        INNER JOIN SILKROAD_R_SHARD.._Inventory   inv WITH (NOLOCK) ON gm.CharID = inv.CharID
        INNER JOIN SILKROAD_R_SHARD.._Items       i   WITH (NOLOCK) ON inv.ItemID = i.ID64
        INNER JOIN SILKROAD_R_SHARD.._RefObjCommon roc WITH (NOLOCK) ON i.RefItemID = roc.ID
        INNER JOIN SILKROAD_R_SHARD.._RefObjItem   roi WITH (NOLOCK) ON roc.Link    = roi.ID
        LEFT  JOIN SILKROAD_R_SHARD.._BindingOptionWithItem bo ON inv.ItemID = bo.nItemDBID

        WHERE
            inv.Slot IN (0,1,2,3,4,5,6,7,8,9,10,11,12)
            AND inv.ItemID > 0
            AND g.ID > 0

        GROUP BY
            g.ID, g.Name, g.Lvl, g.GatheredSP

        ORDER BY
            ItemPoints DESC,
            g.Lvl DESC,
            g.GatheredSP DESC;
    ";

    $stmt = $conn->prepare($query);
    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Ã–nbelleÄŸe yaz (mevcut formatÄ±nÄ± koruyarak)
    @file_put_contents($cacheFile, serialize(json_encode($rows ?: [])), LOCK_EX);
    $result = json_encode($rows ?: []);
} else {
    $result = @unserialize(@file_get_contents($cacheFile));
}

$ranking = json_decode($result ?: '[]', true);
?>

<style>
  /* # sÃ¼tununda sayÄ± ortalanmÄ±ÅŸ */
  .table_rank .td2 { white-space: nowrap; text-align: center; }
  .table_rank .td2 .rank-no { vertical-align: middle; font-weight: 600; }
  
  /* Rozet ikonu iÃ§in yeni sÃ¼tun */
  .table_rank .th-badge, 
  .table_rank .td-badge { 
    width: 30px; 
    text-align: center; 
    padding: 0;
  }
  .table_rank .td-badge img {
    height: 16px;
    width: auto;
    vertical-align: middle;
    display: inline-block;
  }
</style>

<div id="rankmain">
    <div id="rankmenu_container">
        <div id="menu_prev" onclick="slideMenu('prev')">‹</div>
        <div id="menu_next" onclick="slideMenu('next')">›</div>
        <div id="menu_wrapper">
            <ul id="rankmenu">
            <li><a href="ranking.php">Player</a></li>
            <li class="selected"><a href="ranking_guild.php">Guild</a></li>
            <li><a href="ranking_unique.php">Unique</a></li>
            <li><a href="ranking_level.php">Level</a></li>
            <li><a href="ranking_vip.php">Vip</a></li>
            <li><a href="ranking_hunter.php">Hunter</a></li>
            <li><a href="ranking_thief.php">Thief</a></li>
            <li><a href="ranking_fortress_player.php">FTW (Player)</a></li>
            <li><a href="ranking_fortress_guild.php">FTW (Guild)</a></li>
        </ul>
        </div>
    </div>

    <table class="table_rank" cellpadding="0" cellspacing="0">
        <tr>
            <th class="th2">#</th>
            <th class="th-badge"></th>
            <th class="th3">Members</th>
            <th class="th4">Guild</th>
            <th class="th5">Point</th>
            <th class="th6">Change</th>
        </tr>
        <?php if (!empty($ranking)) {
            $count = 1;
            foreach ($ranking as $guild) {

                // Ä°lk 3 iÃ§in rozet
                $badge = '';
                switch ($count) {
                    case 1: $badge = '<img src="images/rank1.png" alt="1st" />'; break;
                    case 2: $badge = '<img src="images/rank2.png" alt="2nd" />'; break;
                    case 3: $badge = '<img src="images/rank3.png" alt="3rd" />'; break;
                }

                $name       = htmlspecialchars($guild['Name'] ?? '-', ENT_QUOTES, 'UTF-8');
                $itemPoints = (int)($guild['ItemPoints'] ?? 0);
                $members    = (int)($guild['TotalMember'] ?? 0);
                ?>
                <tr onMouseOver='this.style.background="#2e261e"' onMouseOut='this.style.background="none"'>
                    <td class="td2"><span class="rank-no"><?= $count ?></span></td>
                    <td class="td-badge"><?= $badge ?></td>
                    <td class="td3"><?= $members ?></td>
                    <td class="td4"><?= $name ?></td>
                    <td class="td5"><?= $itemPoints ?></td>
                    <td class="td6"><div style="text-align:center"><img style="width:16px;height:16px" src="images/nochange.png" title="No Change"></div></td>
                </tr>
                <?php $count++; ?>
            <?php } ?>
        <?php } else { ?>
            <tr><td data-toggle="collapse" colspan="6" class="react-bs-table-no-data" style="text-align: center">No data to display.</td></tr>
        <?php } ?>
    </table>

    <div id="button_website" onclick="window.open('<?= $btnUrl ?>','_blank');return false;">Official Site</div>
</div>

</body>
</html>
