﻿<?php include 'head.php'; ?>
<?php
// ---------- Ayarlar ----------
$REFRESH   = isset($_GET['refresh']);     // cache'i baypas: ?refresh=1
$cacheDir  = dirname(__FILE__).'/cache';
$cacheFile = $cacheDir.'/vip.txt';
$cacheTtl  = 3600; // sn (istersen 3600 yap)
$collation = 'Turkish_CI_AS';

// KlasÃ¶r
if (!is_dir($cacheDir)) { @mkdir($cacheDir, 0775, true); }

// Cache oku (eÄŸer istenmiyorsa veya sÃ¼resi dolmuÅŸsa sorguya gireceÄŸiz)
$useCache = !$REFRESH && file_exists($cacheFile) && filemtime($cacheFile) >= time()-$cacheTtl;

if ($useCache) {
    $raw = @file_get_contents($cacheFile);
    $result = @unserialize($raw);
    $vipRanking = json_decode($result ?: '[]', true);
} else {
    try {
        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // --- AsÄ±l sorgu (ROW_NUMBER ile her UserJID iÃ§in en iyi karakter) ---
        $sql = "
            WITH BestChar AS (
                SELECT
                    scn.[UserJID],
                    c.[CharName16],
                    c.[CurLevel],
                    c.[RefObjID],
                    ROW_NUMBER() OVER (
                        PARTITION BY scn.[UserJID]
                        ORDER BY c.[CurLevel] DESC, c.[CharName16] COLLATE {$collation} ASC
                    ) AS rn
                FROM [SILKROAD_R_ACCOUNT].[dbo].[SR_ShardCharNames] AS scn WITH (NOLOCK)
                INNER JOIN [SILKROAD_R_SHARD].[dbo].[_Char] AS c WITH (NOLOCK)
                    ON c.[CharName16] COLLATE {$collation} = scn.[CharName] COLLATE {$collation}
                   AND c.[Deleted] = 0
            )
            SELECT TOP (20)
                bc.[CharName16],
                bc.[CurLevel],
                bc.[RefObjID],
                ISNULL(v1.[SumSilk], 0) AS MonthlyPoint,
                v3.[SumSilk] AS ThreeMonthPoint
            FROM [GB_JoymaxPortal].[dbo].[MU_Vip3] AS v3 WITH (NOLOCK)
            LEFT JOIN [GB_JoymaxPortal].[dbo].[MU_Vip1] AS v1 WITH (NOLOCK)
                   ON v1.[JID] = v3.[JID]
            INNER JOIN BestChar AS bc
                    ON bc.[UserJID] = v3.[JID] AND bc.rn = 1
            WHERE ISNULL(v3.[SumSilk], 0) > 0
            ORDER BY v3.[SumSilk] DESC,
                     ISNULL(v1.[SumSilk], 0) DESC,
                     bc.[CharName16] COLLATE {$collation} ASC;
        ";

        $stmt = $conn->prepare($sql);
        $stmt->execute();
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // --- vip.txt'ye yaz ---
        $payload = json_encode($rows ?: []);
        @file_put_contents($cacheFile, serialize($payload), LOCK_EX);

        $vipRanking = $rows;
    } catch (Throwable $e) {
        echo '<pre style="white-space:pre-wrap;color:#f88;background:#300;padding:8px;border:1px solid #600">'
            .'SQL HatasÄ±: '.htmlspecialchars($e->getMessage(), ENT_QUOTES, 'UTF-8').'</pre>';
        $vipRanking = [];
    }
}
?>

<style>
  /* # sÃ¼tununda sayÄ± ortalanmÄ±ÅŸ */
  .table_rank .td2 { white-space: nowrap; text-align: center; }
  .table_rank .td2 .rank-no { vertical-align: middle; font-weight: 600; }
  
  /* VIP ikonu iÃ§in yeni sÃ¼tun */
  .table_rank .th-vip, 
  .table_rank .td-vip { 
    width: 30px; 
    text-align: center; 
    padding: 0;
  }
  .table_rank .td-vip img {
    height: 16px;
    width: auto;
    vertical-align: middle;
    display: inline-block;
  }
</style>

<div id="rankmain">
  <div id="rankmenu_container">
        <div id="menu_prev" onclick="slideMenu('prev')">‹</div>
        <div id="menu_next" onclick="slideMenu('next')">›</div>
        <div id="menu_wrapper">
            <ul id="rankmenu">
      <li><a href="ranking.php">Player</a></li>
      <li><a href="ranking_guild.php">Guild</a></li>
      <li><a href="ranking_unique.php">Unique</a></li>
      <li><a href="ranking_level.php">Level</a></li>
      <li class="selected"><a href="ranking_vip.php">Vip</a></li>
      <li><a href="ranking_hunter.php">Hunter</a></li>
      <li><a href="ranking_thief.php">Thief</a></li>
      <li><a href="ranking_fortress_player.php">FTW (Player)</a></li>
      <li><a href="ranking_fortress_guild.php">FTW (Guild)</a></li>
    </ul>
        </div>
    </div>

  <table class="table_rank" cellpadding="0" cellspacing="0">
    <tr>
      <th class="th2">#</th>
      <th class="th-vip"></th>
      <th class="th3">Race</th>
      <th class="th4">Character</th>
      <th class="th5">Monthly Point</th>
      <th class="th6">3 Month Point</th>
    </tr>

    <?php if (!empty($vipRanking)) {
      $count = 1;
      foreach ($vipRanking as $row) {

        // VIP ikonu belirleme (ilk 10 iÃ§in viplevel_6, 11-20 iÃ§in viplevel_5)
        if ($count <= 10) {
            $vipIcon = '<img src="images/viplevel_6.jpg" alt="VIP 6" />';
        } else {
            $vipIcon = '<img src="images/viplevel_5.jpg" alt="VIP 5" />';
        }

        // Race ikonu
        $raceIcon = ((int)($row['RefObjID'] ?? 0) > 2000)
            ? '<img src="images/european.png" alt="EU" style="vertical-align:middle;" />'
            : '<img src="images/chinese.png" alt="CH" style="vertical-align:middle;" />';

        $charName = htmlspecialchars($row['CharName16'] ?? '-', ENT_QUOTES, 'UTF-8');
        $monthly  = number_format((float)($row['MonthlyPoint'] ?? 0));
        $threeM   = number_format((float)($row['ThreeMonthPoint'] ?? 0));
        ?>
        <tr onMouseOver='this.style.background="#2e261e"' onMouseOut='this.style.background="none"'>
          <td class="td2"><span class="rank-no"><?= $count ?></span></td>
          <td class="td-vip"><?= $vipIcon ?></td>
          <td class="td3"><?= $raceIcon ?></td>
          <td class="td4"><?= $charName ?></td>
          <td class="td5"><?= $monthly ?></td>
          <td class="td6"><?= $threeM ?></td>
        </tr>
        <?php $count++; ?>
      <?php } ?>
    <?php } else { ?>
      <tr><td colspan="6" class="react-bs-table-no-data" style="text-align:center">No data to display.</td></tr>
    <?php } ?>
  </table>

  <div id="button_website" onclick="window.open('<?= $btnUrl ?>','_blank');return false;">Official Site</div>
</div>

</body>
</html>
