<?php
/**
 * Web Mall Functions
 * Secure and optimized function library
 */

if (!function_exists('bcmul')) {
    function bcmul($leftOperand, $rightOperand, $scale = 0)
    {
        $scale = $scale < 0 ? 0 : (int)$scale;
        $result = (float)$leftOperand * (float)$rightOperand;
        return number_format($result, $scale, '.', '');
    }
}

if (!function_exists('bcdiv')) {
    function bcdiv($leftOperand, $rightOperand, $scale = 0)
    {
        $scale = $scale < 0 ? 0 : (int)$scale;
        $denominator = (float)$rightOperand;
        if ($denominator === 0.0) {
            return '0';
        }
        $result = (float)$leftOperand / $denominator;
        return number_format($result, $scale, '.', '');
    }
}

if (!function_exists('bcsub')) {
    function bcsub($leftOperand, $rightOperand, $scale = 0)
    {
        $scale = $scale < 0 ? 0 : (int)$scale;
        $result = (float)$leftOperand - (float)$rightOperand;
        return number_format($result, $scale, '.', '');
    }
}



class func



{



	private static function pickRowValue($row, $keys, $default = 0)



	{



		if (!is_array($row)) return $default;



		foreach ($keys as $key)



		{



			if (isset($row[$key])) return $row[$key];



		}



		return $default;



	}



	private static $categoryCache = [];



	private static $categoryCacheDefaultLang = 'us';



	private static $charInfoCache = [];










	private static function normalizeHistoryEntry(array $row)

	{

		$entry = is_array($row) ? $row : [];

		if (!is_array($row)) return $entry;



		$entry['character_id'] = (int)self::pickRowValue($row, ['character_id','CHARACTER_ID'], 0);

		$entry['character_lv'] = (int)self::pickRowValue($row, ['character_lv','CHARACTER_LV'], 0);

		$entry['item_name_package'] = (string)self::pickRowValue($row, ['item_name_package','ITEM_NAME_PACKAGE','item_name','ITEM_NAME'], '');

		$entry['message'] = trim((string)self::pickRowValue($row, ['message','MESSAGE'], ''));

		$entry['reg_ip'] = (string)self::pickRowValue($row, ['reg_ip','REG_IP'], '');

		$entry['reg_date'] = self::pickRowValue($row, ['reg_date','REG_DATE'], null);

		$receive = self::pickRowValue($row, ['receive_date','recieve_date','RECEIVE_DATE','RECIEVE_DATE'], null);

		if ($receive === null && isset($entry['reg_date'])) $receive = $entry['reg_date'];

		$entry['receive_date'] = $receive;

		$entry['invoice_id'] = self::pickRowValue($row, ['invoice_id','INVOICE_ID'], null);

		$entry['cp_invoice_id'] = self::pickRowValue($row, ['cp_invoice_id','CP_INVOICE_ID','cpinvoiceid','CPINVOICEID'], null);

		$entry['silk_own'] = (int)self::pickRowValue($row, ['silk_own','SILK_OWN'], 0);

		$entry['silk_own_premium'] = (int)self::pickRowValue($row, ['silk_own_premium','SILK_OWN_PREMIUM'], 0);



		return $entry;

	}





	private static function historyBaseCte()

	{
		return <<<'SQL'
WITH HistorySource AS (
    SELECT
        B.[character_id],
        B.[character_lv],
        B.[item_name_package],
        B.[silk_own],
        B.[silk_own_premium],
        B.[reg_ip],
        B.[reg_date],
        B.[recieve_date],
        B.[invoice_id],
        B.[cp_invoice_id],
        CASE WHEN B.[message] = '$game_gift' THEN '$game' ELSE B.[message] END AS [message]
    FROM [WEB_ITEM_GIVE_LIST_GIFT] AS A WITH (NOLOCK)
    INNER JOIN [WEB_ITEM_GIVE_LIST] AS B WITH (NOLOCK) ON B.[idx] = A.[ref_idx]
    WHERE A.[from_jid] = ?
    UNION ALL
    SELECT
        G.[character_id],
        G.[character_lv],
        G.[item_name_package],
        G.[silk_own],
        G.[silk_own_premium],
        G.[reg_ip],
        G.[reg_date],
        G.[recieve_date],
        G.[invoice_id],
        G.[cp_invoice_id],
        G.[message]
    FROM [WEB_ITEM_GIVE_LIST] AS G WITH (NOLOCK)
    WHERE G.[cp_jid] = ?
)
SQL;
	}


	private static function loadCategoryMap($lang)



	{



		$allowed = ['us','tr','eg','de','es'];



		if (!in_array($lang, $allowed, true)) $lang = self::$categoryCacheDefaultLang;



		if (isset(self::$categoryCache[$lang])) return self::$categoryCache[$lang];



		$shopCol = '[shop_name_' . $lang . ']';



		$subCol = '[sub_name_' . $lang . ']';



		$sql = "SELECT A.[shop_no], A.".$shopCol." AS shop_name, B.[sub_no], B.".$subCol." AS sub_name FROM [WEB_MALL_CATEGORY] AS A WITH (NOLOCK) INNER JOIN [WEB_MALL_CATEGORY_SUB] AS B WITH (NOLOCK) ON B.[ref_no] = A.[shop_no] ORDER BY A.[shop_no], B.[sub_no]";



		$cache = [];



		if ($dbo = db::mssqlexec($sql, null, 2))



		{



			if ($dbo->RowCount() > 0)



			{



				while (!$dbo->EOF)



				{



					$row = $dbo->fields;



					if (!is_array($row)) { $dbo->MoveNext(); continue; }



				$shopNo = (int)(isset($row['shop_no']) ? $row['shop_no'] : 0);



				$subNo = (int)(isset($row['sub_no']) ? $row['sub_no'] : 0);



				$shopName = isset($row['shop_name']) ? $row['shop_name'] : '';



				$subName = isset($row['sub_name']) ? $row['sub_name'] : '';



					if (!isset($cache[$shopNo])) $cache[$shopNo] = ['name' => $shopName, 'subs' => []];



					$cache[$shopNo]['subs'][$subNo] = $subName;



					$dbo->MoveNext();



				}



			}



			$dbo->Close();



		}



		return self::$categoryCache[$lang] = $cache;



	}



	public static function mallpackageitems($st0, $st1, $st2)
	{
		$st0 = (int)$st0;
		$st1 = (int)$st1;
		$st2 = (int)$st2;
		
		$dbo = db::mssqlexec("SELECT * FROM [VW_WEB_MALL_LIST] WITH (NOLOCK) WHERE [silk_type]=? AND [ref_no]=? AND [sub_no]=?", [$st0, $st1, $st2], 2);
		if (!$dbo || $dbo->RowCount() == 0) return false;
		return $dbo;
	}



	public static function i_am_gm($jid)
	{
		$jid = (int)$jid;
		$userInfo = self::tbuserinfo($jid);
		if (!$userInfo || !is_array($userInfo)) return false;
		
		return (isset($userInfo['sec_primary']) && $userInfo['sec_primary'] == 1 && 
		        isset($userInfo['sec_content']) && $userInfo['sec_content'] == 1);
	}



	public static function getjcash($pjid)
	{
		$pjid = (int)$pjid;
		$dbo = db::mssqlexec("EXEC [".PORTALDB."]..[X_GetJCash] ?", $pjid);
		if (!$dbo || $dbo->RowCount() == 0) {
			return [
				0 => 0, 1 => 0, 2 => 0, 3 => 0, 4 => 0,
				'premium' => 0, 'silk' => 0, 'month_usage' => 0,
				'three_month_usage' => 0, 'webpoint' => 0
			];
		}
		
		$row = $dbo->FetchRow();
		if (!is_array($row)) {
			return [
				0 => 0, 1 => 0, 2 => 0, 3 => 0, 4 => 0,
				'premium' => 0, 'silk' => 0, 'month_usage' => 0,
				'three_month_usage' => 0, 'webpoint' => 0
			];
		}

		$premium = (int)self::pickRowValue($row, ['PremiumSilk','premium_silk',0], 0);
		$silk = (int)self::pickRowValue($row, ['Silk','silk',1], 0);
		$monthUsage = (int)self::pickRowValue($row, ['LatestMonthUsage','MonthUsage',2], 0);
		$threeMonth = (int)self::pickRowValue($row, ['Past3MonthsUsage','Usage3Month',3], 0);
		$webPoint = (int)self::pickRowValue($row, ['WebPoint','webpoint',4], 0);

		return [
			0 => $premium,
			1 => $silk,
			2 => $monthUsage,
			3 => $threeMonth,
			4 => $webPoint,
			'premium' => $premium,
			'silk' => $silk,
			'month_usage' => $monthUsage,
			'three_month_usage' => $threeMonth,
			'webpoint' => $webPoint,
		];
	}



	public static function getboughtcount($jid, $pcode)
	{
		$jid = (int)$jid;
		$pcode = trim($pcode);
		
		$servtime = self::getservtime();
		if (!$servtime) return 0;
		
		$month = $servtime->format('m');
		$dbo = db::mssqlexec("SELECT * FROM [WEB_ITEM_GIVE_LIST] WITH (NOLOCK) WHERE [cp_jid]=? AND [item_code_package]=? AND DATEPART(MONTH, [reg_date])=?", [$jid, $pcode, $month]);
		if (!$dbo) return 0;
		return $dbo->RowCount();
	}



	public static function getvipinfo($pjid)
	{
		$pjid = (int)$pjid;
		$dbo = db::mssqlexec("SELECT * FROM [".PORTALDB."]..[MU_VIP_Info] WITH (NOLOCK) WHERE [JID]=?", $pjid);
		if (!$dbo || $dbo->RowCount() == 0) return [0, 0];
		
		$vip = $dbo->FetchRow();
		if (!is_array($vip) || !isset($vip['ExpireDate'])) return [0, 0];
		
		try {
			$_expiry_date = new DateTime($vip['ExpireDate']);
			$servtime = self::getservtime();
			if (!$servtime) return [0, 0];
			
			if ($_expiry_date->format('Y-m-d H:i:s') > $servtime->format('Y-m-d H:i:s'))
			{
				$vipType = isset($vip['VIPUserType']) ? (int)$vip['VIPUserType'] : 0;
				$vipLv = isset($vip['VIPLv']) ? (int)$vip['VIPLv'] : 0;
				return [$vipType, $vipLv];
			}
		} catch (Exception $e) {
			self::writelog("Error in getvipinfo: " . $e->getMessage());
		}
		
		return [0, 0];
	}



	public static function tbuserinfo($jid)
	{
		$jid = (int)$jid;
		if ($jid <= 0) return false;
		
		$dbo = db::mssqlexec("SELECT * FROM [TB_User] WITH (NOLOCK) WHERE [JID]=?", $jid);
		if (!$dbo || $dbo->RowCount() == 0) return false;
		return $dbo->FetchRow();
	}



	public static function getpurchasehistorymaxrow($jid)
	{
		$jid = (int)$jid;
		if ($jid <= 0) return 0;
		
		$dbo = db::mssqlexec("SELECT * FROM [WEB_ITEM_GIVE_LIST] WITH (NOLOCK) WHERE [cp_jid]=? ORDER BY [reg_date] DESC", $jid);
		if (!$dbo || $dbo->RowCount() == 0) return 0;
		return $dbo->RowCount();
	}



	public static function gethistoryspent($jid)
	{
		$jid = (int)$jid;
		$cte = self::historyBaseCte();
		$sql = $cte . "
SELECT
    COALESCE(SUM(CASE WHEN H.[message] = '\$game' THEN H.[silk_own] ELSE 0 END), 0) AS silk_own,
    COALESCE(SUM(CASE WHEN H.[message] = '\$game' THEN H.[silk_own_premium] ELSE 0 END), 0) AS silk_own_premium
FROM HistorySource AS H";
		$params = [$jid, $jid];
		$dbo = db::mssqlexec($sql, $params, 2);
		if (!$dbo) return [0, 0];
		$row = $dbo->FetchRow();
		$dbo->Close();
		if (!is_array($row)) return [0, 0];
		$silk = (int)self::pickRowValue($row, ['silk_own', 'SILK_OWN', 0], 0);
		$premium = (int)self::pickRowValue($row, ['silk_own_premium', 'SILK_OWN_PREMIUM', 1], 0);
		return [0 => $silk, 1 => $premium, 'silk_own' => $silk, 'silk_own_premium' => $premium];
	}


	public static function gethistory($jid, $yr, $mn, $rows, $page)
	{
		$jid = (int)$jid;
		$yr = (int)$yr;
		$mn = (int)$mn;
		$rows = (int)$rows;
		$page = (int)$page;
		if ($rows <= 0) $rows = 25;
		if ($page <= 0) $page = 1;
		$offset = ($page - 1) * $rows;

		$conditions = [];
		$paramsFilters = [];
		if ($yr > 0) {
			$conditions[] = "YEAR(H.[reg_date]) = ?";
			$paramsFilters[] = $yr;
		}
		if ($mn > 0) {
			$conditions[] = "MONTH(H.[reg_date]) = ?";
			$paramsFilters[] = $mn;
		}
		$where = empty($conditions) ? '' : ' WHERE ' . implode(' AND ', $conditions);

		$cte = self::historyBaseCte();
		$countSql = $cte . '
SELECT COUNT(*) AS total FROM HistorySource AS H' . $where;
		$countParams = array_merge([$jid, $jid], $paramsFilters);
		$maxpurchase = 0;
		if ($dbo = db::mssqlexec($countSql, $countParams, 2))
		{
			$row = $dbo->FetchRow();
			$dbo->Close();
			if (is_array($row)) $maxpurchase = (int)self::pickRowValue($row, ['total', 0], 0);
		}

		$dataSql = $cte . '
SELECT
    H.[character_id],
    H.[character_lv],
    H.[item_name_package],
    H.[silk_own],
    H.[silk_own_premium],
    H.[reg_ip],
    H.[reg_date],
    H.[recieve_date],
    H.[invoice_id],
    H.[cp_invoice_id],
    H.[message],
    CASE WHEN H.[recieve_date] IS NULL THEN H.[reg_date] ELSE H.[recieve_date] END AS receive_date
FROM HistorySource AS H' . $where . ' ORDER BY H.[reg_date] DESC';
		$dataSql .= ' OFFSET ? ROWS FETCH NEXT ? ROWS ONLY';
		$dataParams = array_merge([$jid, $jid], $paramsFilters, [$offset, $rows]);
		$entries = [];
		if ($data = db::mssqlexec($dataSql, $dataParams, 2))
		{
			while (!$data->EOF)
			{
				$row = $data->fields;
				if (is_array($row)) $entries[] = self::normalizeHistoryEntry($row);
				$data->MoveNext();
			}
			$data->Close();
		}

		if ($maxpurchase == 0 && !empty($entries)) $maxpurchase = count($entries);
		return [$maxpurchase, $entries];
	}


	public static function getreserved($jid)
	{
		$jid = (int)$jid;
		if ($jid <= 0) return false;
		
		$dbo = db::mssqlexec("SELECT A.[idx], B.* FROM [WEB_ITEM_RESERVED] AS A WITH (NOLOCK) INNER JOIN [VW_WEB_MALL_LIST] AS B WITH (NOLOCK) ON B.[package_id] = A.[package_id] WHERE A.[userjid]=? ORDER BY A.[idx] DESC", $jid, 2);
		if (!$dbo || $dbo->RowCount() == 0) return false;
		return $dbo;
	}



	public static function delreserved($jid, $idx=null)
	{
		$jid = (int)$jid;
		if ($jid <= 0) return false;
		
		if ($idx == "all")
		{
			db::mssqlexec("DELETE FROM [WEB_ITEM_RESERVED] WHERE [userjid]=?", $jid);
			return true;
		}
		else if ($idx != null)
		{
			$idx = (int)$idx;
			db::mssqlexec("DELETE FROM [WEB_ITEM_RESERVED] WHERE [userjid]=? AND [idx]=?", [$jid, $idx]);
			return true;
		}
		return false;
	}

	// Reserved'dan package_id'ye göre sil
	public static function delreservedbypackage($jid, $package_id)
	{
		$jid = (int)$jid;
		$package_id = (int)$package_id;
		if ($jid <= 0 || $package_id <= 0) return false;
		
		db::mssqlexec("DELETE FROM [WEB_ITEM_RESERVED] WHERE [userjid]=? AND [package_id]=?", [$jid, $package_id]);
		return true;
	}



	public static function getmallitems($p, $ps, $st0, $st1, $st2, $kw='')
	{
		$p = (int)$p;
		$ps = (int)$ps;
		$st0 = (int)$st0;
		$st1 = (int)$st1;
		$st2 = (int)$st2;
		$kw = trim($kw);
		
		if ($p <= 0) $p = 1;
		if ($ps <= 0) $ps = 25;
		
		$dbo = db::mssqlexec("EXEC [".ACCOUNTDB."]..[WEB_ITEM_BUY_GAME_LIST_X] ?,?,?,?,?,?,?", [$p, $ps, $st0, $st1, $st2, 1, $kw], 2);
		if (!$dbo || $dbo->RowCount() == 0) return false;
		return $dbo;
	}



	public static function getcharinfo($charid)
	{
		$charid = (int)$charid;
		if ($charid <= 0) return false;
		
		if (isset(self::$charInfoCache[$charid])) {
			return self::$charInfoCache[$charid];
		}

		$dbo = db::mssqlexec("SELECT [CharID],[CharName16] FROM [SILKROAD_R_SHARD].[DBO].[_Char] WITH (NOLOCK) WHERE [CharID]=?", $charid);
		if (!$dbo || $dbo->RowCount() == 0)
		{
			self::$charInfoCache[$charid] = false;
			return false;
		}
		
		$row = $dbo->FetchRow();
		self::$charInfoCache[$charid] = $row;
		return $row;
	}



	public static function getshardcharnamejid($charname)
	{
		if (empty($charname) || !is_string($charname)) return false;
		
		$charname = trim($charname);
		$dbo = db::mssqlexec("SELECT [UserJID] FROM [SILKROAD_R_ACCOUNT].[DBO].[SR_ShardCharNames] WITH (NOLOCK) WHERE [CharName]=?", $charname);
		if (!$dbo || $dbo->RowCount() == 0) return false;
		
		$row = $dbo->FetchRow();
		if (!is_array($row)) return false;
		
		return isset($row[0]) ? (int)$row[0] : false;
	}



	public static function addreserved($jid, $pid)
	{
		$jid = (int)$jid;
		$pid = (int)$pid;
		
		if ($jid <= 0 || $pid <= 0) return false;
		
		$dbo = db::mssqlexec("EXEC [".ACCOUNTDB."]..[WEB_ITEM_RESERVED_X] ?,?", [$jid, $pid]);
		if (!$dbo || $dbo->RowCount() == 0) return false;
		
		$row = $dbo->FetchRow();
		if (!is_array($row)) return false;
		
		return isset($row[0]) ? (int)$row[0] : false;
	}



	public static function newitempurchase($jid, $st0, $price_offset, $pid, $pt_inv_id, $cp_inv_id, $servername, $tojid)
	{
		//JCISCode	JCISName
		//7000		Begin PS~CP TX By PS
		//10000		Complete PS~CP TX By PS(JCash subtracted)
		//5000		Complete PS~PG TX By PS(JCash supplied)
		//8000		Fail PS~CP TX By CP(CPCash not supplied)
		//6000		Fail PS~CP TX By PS(Begin PS~CP TX Error)
		//9000		Fail PS~CP TX By PS(JCash not subtracted)
		//4000		Fail PS~PG TX By PS(JCash not supplied)

		if ($tojid < 0) return -65;

		$ip2hex = self::getipvisitor(true);
		$tb_info = self::tbuserinfo($jid);
		
		if (!$tb_info || !is_array($tb_info)) return -66;
		
		$pjid = isset($tb_info['PortalJID']) ? $tb_info['PortalJID'] : 0;
		$package_info = self::getpackagedetail($pid);
		
		if (!$package_info || !is_array($package_info)) return -67;
		
		$package_code = isset($package_info['package_code']) ? $package_info['package_code'] : '';
		$package_name = isset($package_info['package_name']) ? $package_info['package_name'] : '';
		$serviceCompany = isset($tb_info['ServiceCompany']) ? $tb_info['ServiceCompany'] : 0;
		
		$args = [$pt_inv_id, $cp_inv_id, $serviceCompany, $price_offset, $st0, $pjid, hexdec($ip2hex), $package_code, $package_name, 1, $servername];

		if ($step1 = db::mssqlexec("EXEC [".PORTALDB."]..[X_DirectPaymentBeginCPTXByPS] ?,?,?,?,?,?,?,?,?,?,?", $args))
		{
			$retval = $step1->FetchRow();
			if (!is_array($retval) || !isset($retval['ReturnCode'])) return -68;
			if ($retval['ReturnCode'] < 0) return $retval['ReturnCode'];

			if ($retval['ReturnCode'] == 7000)
			{
				if ($step2 = db::mssqlexec("EXEC [".PORTALDB."]..[X_DirectPaymentCompletedCPTXByPS] ?", $pt_inv_id))
				{
					$retval = $step2->FetchRow();
					if (!is_array($retval) || !isset($retval['ReturnCode'])) return -69;
					if ($retval['ReturnCode'] < 0) return $retval['ReturnCode'];
					
					if ($retval['ReturnCode'] == 10000)
					{
						if ($tojid == $jid) $tojid = 0; // if recipient jid is equal to sender, let set to 0 for none gift transaction
						$args = [$jid, $st0, $price_offset, 323, $servername, $pid, 1, ($tojid == 0 ? '$game' : '$game_gift'), self::getipvisitor(), $pt_inv_id, $cp_inv_id, $tojid];

						if ($step3 = db::mssqlexec("EXEC [".ACCOUNTDB."]..[WEB_ITEM_BUY_X] ?,?,?,?,?,?,?,?,?,?,?,?", $args))
						{
							$retval = $step3->FetchRow();
							if (!is_array($retval) || !isset($retval['RetVal'])) return -70;
							
							if ($retval['RetVal'] < 0)
							{
								self::writelog("WEB_ITEM_BUY_X RETURNED (".$retval['RetVal'].")", "buy_function_error.log");
								return $retval['RetVal'];
							}
							
							// Başarılı satın alma - Reserved'dan sil
							self::delreservedbypackage($jid, $pid);
							
							return $retval['RetVal'];
						}
						else { 
							self::writelog("FAILED TO EXECUTE WEB_ITEM_BUY_X", "buy_function_error.log"); 
							return -5; 
						}
					} else { 
						self::writelog("X_DirectPaymentCompletedCPTXByPS RETURNED (".$retval['ReturnCode'].")", "buy_function_error.log"); 
						return -4; 
					}
				} else { 
					self::writelog("FAILED TO EXECUTE X_DirectPaymentCompletedCPTXByPS", "buy_function_error.log"); 
					return -3; 
				}
			} else { 
				self::writelog("X_DirectPaymentBeginCPTXByPS RETURNED (".$retval['ReturnCode'].")", "buy_function_error.log"); 
				return -2; 
			}
		} else { 
			self::writelog("FAILED TO EXECUTE X_DirectPaymentBeginCPTXByPS", "buy_function_error.log"); 
			return -1; 
		}
	}



	public static function getpackagedetail($pid)
	{
		$pid = (int)$pid;
		if ($pid <= 0) return false;
		
		$dbo = db::mssqlexec("SELECT * FROM [VW_WEB_MALL_LIST] WITH (NOLOCK) WHERE [package_id]=? AND [service]=1", $pid, 2);
		if (!$dbo || $dbo->RowCount() == 0) return false;
		return $dbo->FetchRow();
	}



	public static function getitemscount($st0, $st1, $st2)



	{



		$dbo=db::mssqlexec("SELECT * FROM [WEB_PACKAGE_ITEM] WITH (NOLOCK) WHERE [service]=1 AND [silk_type]=? AND [shop_no]=? AND [shop_no_sub]=?", [$st0, $st1, $st2]);



		if (!$dbo || $dbo->RowCount() == 0) return 0;



		return $dbo->RowCount();



	}



	public static function popularitem()



	{



		$dbo=db::mssqlexec("SELECT A.*, B.[package_code], B.[silk_price], B.[silk_type], B.[discount_rate] FROM [WEB_ITEM_POPULAR] AS A WITH (NOLOCK) INNER JOIN [VW_WEB_MALL_LIST] AS B WITH (NOLOCK) ON B.[package_id] = A.[package_id] ORDER BY A.[idx]", null, 2);



		if (!$dbo || $dbo->RowCount() == 0) return false;



		return $dbo;	



	}



	public static function newbestcount($type, $silk, $count)



	{



		switch ($type)



		{



			case "new":



				$dbo=db::mssqlexec("SELECT * FROM [VW_WEB_MALL_LIST] WHERE [is_new]=1 AND [service]=1 AND [silk_type]=? ORDER BY [reg_date] DESC", $silk, 2, $count);



				break;



			case "best":



				$dbo=db::mssqlexec("SELECT * FROM [VW_WEB_MALL_LIST] WHERE [is_best]=1 AND [service]=1 AND [silk_type]=? ORDER BY [reg_date] DESC", $silk, 2, $count);



				break;



			default: return false;



		}



		if (!$dbo || $dbo->RowCount() == 0) return [false];



		return [true, $dbo];



	}



	public static function certifykey($jid)
	{
		if ($dbo = db::mssqlexec("SELECT [Certifykey] FROM [WEB_ITEM_CERTIFYKEY] WITH (NOLOCK) WHERE [UserJID]=? ORDER BY [reg_date] DESC", $jid, null, 1))
		{
			if ($dbo->RowCount() == 0)
			{
				self::writelog('[C106] No certify key row found at certifykey() '
					.'QS='.(isset($_SERVER['QUERY_STRING']) ? (string)$_SERVER['QUERY_STRING'] : '')
					.' POST='.json_encode(isset($_POST) ? $_POST : []),
					'db_errors.log');
				return -1;
			}

			$row = $dbo->FetchRow();
			$certifyKey = null;
			if (is_array($row))
			{
				if (isset($row['Certifykey']) && $row['Certifykey'] !== '')
				{
					$certifyKey = $row['Certifykey'];
				}
				elseif (array_key_exists(0, $row) && $row[0] !== '')
				{
					$certifyKey = $row[0];
				}
			}
			if ($certifyKey === null)
			{
				self::writelog('[C106] Empty Certifykey value at certifykey() '
					.'QS='.(isset($_SERVER['QUERY_STRING']) ? (string)$_SERVER['QUERY_STRING'] : '')
					.' POST='.json_encode(isset($_POST) ? $_POST : []),
					'db_errors.log');
				return -1;
			}

			return $certifyKey;
		}

		self::writelog('[C106] Query handle missing at certifykey() '
			.'QS='.(isset($_SERVER['QUERY_STRING']) ? (string)$_SERVER['QUERY_STRING'] : '')
			.' POST='.json_encode(isset($_POST) ? $_POST : []),
			'db_errors.log');
		return -1;
	}



	public static function category($cat1, $cat2, $lang="us")



	{



		$localized = [



			'us' => ['New & Best','New','Best'],



			'de' => ['Neu & Besten','Neu','Besten'],



			'es' => ['Nueva & Mejor','Nueva','Mejor'],



			'tr' => ['Populer','Yeni','En Iyi'],



			'eg' => ['New & Best','New','Best'],



		];



		$langKey = isset($localized[$lang]) ? $lang : self::$categoryCacheDefaultLang;



		if ($cat1 == 0 && $cat2 == 0) return $localized[$langKey];



		$map = self::loadCategoryMap($langKey);



		if (isset($map[$cat1]))



		{



			$shopName = $map[$cat1]['name'];



			if ($cat2 != 0 && isset($map[$cat1]['subs'][$cat2]))



			{



				return [$shopName, $map[$cat1]['subs'][$cat2]];



			}



			return [$shopName, $shopName];



		}



		$default = $localized[self::$categoryCacheDefaultLang];



		return [$default[0], $default[1]];



	}



	public static function init_common()
	{
		$cookieOptions = [
			'expires' => time() + 3600,
			'path' => '/',
			'domain' => '',
			'secure' => false,  // Set to true if using HTTPS
			'httponly' => true, // No JavaScript access
			'samesite' => 'Lax'  // Changed from Strict to Lax for better compatibility
		];
		
		if (!isset($_COOKIE['dir']) || $_COOKIE['dir'] != ROOTDIR) {
			setcookie("dir", ROOTDIR, $cookieOptions);
		}
		if (!isset($_COOKIE['ext']) || $_COOKIE['ext'] != EXT) {
			setcookie("ext", EXT, $cookieOptions);
		}
	}



	public static function writelog($logmsg, $file="error.log")
	{
		$logdir = $_SERVER['DOCUMENT_ROOT'] . "/logs/";
		if (!is_dir($logdir)) {
			mkdir($logdir, 0755, true);
		}
		// Sanitize log message to prevent log injection
		$logmsg = str_replace(["\r", "\n"], ' ', $logmsg);
		error_log(date('[Y-m-d H:i:s]: '). $logmsg . PHP_EOL, 3, $logdir . basename($file));
	}



	public static function sessionlog($contents, $file)
	{
		$sessiondir = $_SERVER['DOCUMENT_ROOT']."/sessions/";
		if (!is_dir($sessiondir)) {
			mkdir($sessiondir, 0755, true);
		}
		// Sanitize filename to prevent directory traversal
		$file = basename($file);
		if (file_exists($sessiondir.$file)) return true;
		error_log($contents, 3, $sessiondir . $file);
		return true;
	}



	public static function matchreferer($referer)
	{
		if (empty($referer)) return false;
		$domain = parse_url(HTTP_DOMAIN, PHP_URL_HOST);
		$refererHost = parse_url($referer, PHP_URL_HOST);
		if ($refererHost === false || $refererHost === null) return false;
		return ($domain === $refererHost);
	}



	public static function nbetween($varToCheck, $high, $low)
	{
		if ($varToCheck < $low) return false;
		if ($varToCheck > $high) return false;
		return true;
	}



	public static function getservtime()
	{
		$dbo = db::mssqlexec("SELECT GETDATE()");
		if (!$dbo || $dbo->RowCount() == 0) return false;
		$row = $dbo->FetchRow();
		if (!is_array($row)) return false;
		$firstValue = null;
		foreach ($row as $value) { 
			$firstValue = $value; 
			break; 
		}
		if ($firstValue === null || $firstValue === '') return false;
		try {
			return date_create($firstValue);
		} catch (Exception $e) {
			self::writelog("Error creating date: " . $e->getMessage());
			return false;
		}
	}



	public static function getipvisitor($tohex=false)
	{
		$visitor_ip = '0.0.0.0';
		
		// Check CloudFlare IP first
		if (!empty($_SERVER["HTTP_CF_CONNECTING_IP"]) && filter_var($_SERVER["HTTP_CF_CONNECTING_IP"], FILTER_VALIDATE_IP))
		{
			$visitor_ip = $_SERVER["HTTP_CF_CONNECTING_IP"];
		}
		elseif (!empty($_SERVER['HTTP_CLIENT_IP']) && filter_var($_SERVER['HTTP_CLIENT_IP'], FILTER_VALIDATE_IP))
		{
			$visitor_ip = $_SERVER['HTTP_CLIENT_IP'];
		}
		elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR']))
		{
			// X-Forwarded-For can contain multiple IPs, get the first one
			$ips = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
			$ip = trim($ips[0]);
			if (filter_var($ip, FILTER_VALIDATE_IP)) {
				$visitor_ip = $ip;
			}
		}
		else
		{
			$visitor_ip = $_SERVER['REMOTE_ADDR'];
		}
		
		// Validate IP before returning
		if (!filter_var($visitor_ip, FILTER_VALIDATE_IP)) {
			$visitor_ip = '0.0.0.0';
		}
		
		if ($tohex) return self::ip2hex($visitor_ip);
		return $visitor_ip;
	}



	public static function ip2hex($ip) 
	{
		if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4) !== false) {
			return sprintf("%08x", ip2long($ip));
		}
		if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6) === false) {
			return false;
		}
		if (($ip_n = inet_pton($ip)) === false) return false;
		
		$bits = 15;
		$ipbin = '';
		while ($bits >= 0)
		{
			$bin = sprintf("%02x", (ord($ip_n[$bits])));
			$ipbin = $bin . $ipbin;
			$bits--;
		}
		return $ipbin;
	} 



	public static function str_clean($str)
	{
		// Only allow alphanumeric characters
		if (!is_string($str)) return false;
		$str = trim($str);
		return (preg_match("#^[a-zA-Z0-9]+$#", $str) ? $str : false);
	}



	private static function param_encrypt($string, $key)
	{
		if (!is_string($string) || !is_string($key)) return false;
		
		// Generate a random IV
		$ivLength = openssl_cipher_iv_length("AES-256-CBC");
		$iv = openssl_random_pseudo_bytes($ivLength);
		
		// Encrypt the data
		$encrypted = openssl_encrypt($string, "AES-256-CBC", $key, 0, $iv);
		if (!$encrypted) return false;
		
		// Combine IV and encrypted data, then encode
		return base64_encode($iv . $encrypted);
	}

	private static function param_decrypt($string, $key)
	{
		if (!is_string($string) || !is_string($key)) return false;
		
		$data = base64_decode($string);
		if ($data === false) return false;
		
		// Extract IV and encrypted data
		$ivLength = openssl_cipher_iv_length("AES-256-CBC");
		if (strlen($data) < $ivLength) return false;
		
		$iv = substr($data, 0, $ivLength);
		$encrypted = substr($data, $ivLength);
		
		// Decrypt the data
		$result = openssl_decrypt($encrypted, "AES-256-CBC", $key, 0, $iv);
		if ($result === false) return false;
		
		return $result;
	}	



	public static function gentoken($params, $pass)
	{
		if (!is_string($params) || !is_string($pass)) return false;
		
		$token_enc = self::param_encrypt($params . md5($params), $pass);
		if (!$token_enc) return false;
		
		$cookieOptions = [
			'expires' => time() + 1800, // 30 minutes
			'path' => '/',
			'domain' => '',
			'secure' => false,  // Set to true if using HTTPS
			'httponly' => true,
			'samesite' => 'Lax'  // Changed from Strict to Lax for better compatibility
		];
		
		$parts = explode("|", $params);
		if (isset($parts[3])) {
			setcookie("mlanguage1", $parts[3], $cookieOptions);
		}
		setcookie("webmallkey", $token_enc, $cookieOptions);
		
		return $token_enc;
	}



	public static function readtoken($token, $pass, $checkspan=true)
	{
		if (!is_string($token) || !is_string($pass)) return false;
		
		$token_dec = self::param_decrypt($token, $pass);
		if (!$token_dec) return false; // wrong password
		
		$mdhash = substr($token_dec, (strlen($token_dec) - 32), 32);
		$string = substr($token_dec, 0, (strlen($token_dec) - 32));
		
		if ($mdhash != md5($string)) return -1; // token has been hijacked/edited
		
		$explod = explode("|", $string);
		
		if ($checkspan && isset($explod[0])) { 
			if (time() - $explod[0] > 1800) return -2; // expiration of token
		}
		
		if (count($explod) == 3) {
			return array('jid' => $explod[1], 'key' => $explod[2]);
		}
		if (count($explod) == 4) {
			return array('jid' => $explod[1], 'key' => $explod[2], 'loc' => $explod[3]);
		}
		if (count($explod) == 5) {
			return array('jid' => $explod[1], 'key' => $explod[2], 'loc' => $explod[3], 'day' => $explod[4]);
		}
		
		return false;
	}



	public static function str_starts_with($haystack, $needle)
	{
		if (!is_string($haystack) || !is_string($needle)) return false;
		$needle = (string)$needle;
		if ($needle === '') return false;
		return strncmp((string)$haystack, $needle, strlen($needle)) === 0;
	}

	public static function str_ends_with($haystack, $needle)
	{
		if (!is_string($haystack) || !is_string($needle)) return false;
		$needle = (string)$needle;
		if ($needle === '') return false;
		return substr((string)$haystack, -strlen($needle)) === $needle;
	}

	public static function str_contains($haystack, $needle)
	{
		if (!is_string($haystack) || !is_string($needle)) return false;
		$needle = (string)$needle;
		if ($needle === '') return false;
		$haystack = (string)$haystack;
		if (function_exists('mb_strpos')) {
			return mb_strpos($haystack, $needle) !== false;
		}
		return strpos($haystack, $needle) !== false;
	}
}


























